# helper functiont that does all the work
overlap_score_single<-function(sd,prime,target) 
{ 
  nchar(prime)->primelen
  nchar(target)->targetlen

  if(primelen!=length(sd)) error("primeget Length does not match # of elements in sd");

  ovcalc<-function(sd,len1,len2) # Compute potential overlap of each element from: sd of stimulus, length of stimulus, length of option
  {
    outer(
      1:len1,(1:len2-.5)/len2,  # rescale y centres to 0-1 range
      Vectorize(function(x,y)
        { 
          xloc<-(x-.5)/len1 # rescale x centre
          l<-pnorm(y+.5/len2,xloc,sd[x]/len1)
          r<-pnorm(y-.5/len2,xloc,sd[x]/len1)
          return(abs(l-r))
        }  )
    );
  }

  ovpt<-ovcalc(sd,primelen,targetlen) # for prime stimulus with target "stable representation"

  # identify matching elements
  ptm<-outer(1:primelen,1:targetlen,Vectorize(function(x,y) substr(prime,x,x)==substr(target,y,y)));  

  ov_primetarget<-sum(ovpt*ptm)
  ov_primetarget
}

overlap_score<-Vectorize(overlap_score_single,vectorize.args=c("prime","target"))

# call overlap like overlap_score(c(.5,.5,.5,.5,.5),c("ankle"),c("anxle"))
# parameters are sd(vector),prime,target)
# You can add more prime-target pairs of the same prime length
# To do more than one length, you'll need a different sd vector anyway
# Return a vector of P(correct) for each trial


#load stimuli
read.table("Exp2 Stimuli.txt", header=TRUE)->exp2stim
read.table("Exp3 Stimuli.txt", header=TRUE)->exp3stim

str(exp2stim)
head(exp2stim)

d<-1.5 #new changes; update the number of expected number of parameters as well.
r<-1.2
#d=1.5;r=1.2
sd7<-d*(1-exp(-(1:7-.5)/r))
sd8<-d*(1-exp(-(1:8-.5)/r))

#Exp 2 overlap scores
overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$repTarget)),as.character(tolower(exp2stim$repTarget))) #2.574501
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$repTarget)),as.character(tolower(exp2stim$repTarget)))) #2.574501

overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$uniqTarget)),as.character(tolower(exp2stim$uniqTarget))) #2.352771

mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$rel7PrimeSame)),as.character(tolower(exp2stim$repTarget)))) #1.9627
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$rel7PrimeSame)),as.character(tolower(exp2stim$uniqTarget)))) #1.810293

mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$cont8Prime)),as.character(tolower(exp2stim$repTarget)))) #0.2069851
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$cont8Prime)),as.character(tolower(exp2stim$uniqTarget)))) #0.2069851

mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$cont7prime)),as.character(tolower(exp2stim$repTarget)))) #0.09879636
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp2stim$cont7prime)),as.character(tolower(exp2stim$uniqTarget)))) #0.09879636


###
overlap_score(sd8,as.character(tolower(exp2stim$repTarget)),as.character(tolower(exp2stim$repTarget))) #2.574501, now 2.863419
mean(overlap_score(sd8,as.character(tolower(exp2stim$repTarget)),as.character(tolower(exp2stim$repTarget)))) #2.574501

overlap_score(sd8,as.character(tolower(exp2stim$uniqTarget)),as.character(tolower(exp2stim$uniqTarget))) #2.352771, now 2.658454
mean(overlap_score(sd8,as.character(tolower(exp2stim$uniqTarget)),as.character(tolower(exp2stim$uniqTarget))))

mean(overlap_score(sd7,as.character(tolower(exp2stim$rel7PrimeSame)),as.character(tolower(exp2stim$repTarget)))) #1.9627, now 2.228121
mean(overlap_score(sd7,as.character(tolower(exp2stim$rel7PrimeSame)),as.character(tolower(exp2stim$uniqTarget)))) #1.810293, now 2.076693

mean(overlap_score(sd8,as.character(tolower(exp2stim$cont8Prime)),as.character(tolower(exp2stim$repTarget)))) #0.2069851, now 0.2105691
mean(overlap_score(sd8,as.character(tolower(exp2stim$cont8Prime)),as.character(tolower(exp2stim$uniqTarget)))) #0.2069851, now 0.2105691

mean(overlap_score(sd7,as.character(tolower(exp2stim$cont7prime)),as.character(tolower(exp2stim$repTarget)))) #0.09879636, now 0.1018004
mean(overlap_score(sd7,as.character(tolower(exp2stim$cont7prime)),as.character(tolower(exp2stim$uniqTarget)))) #0.09879636, now 0.1018004

#Exp 3 overlap scores

str(exp3stim)
head(exp3stim)

table(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp3stim$targetSame)),as.character(tolower(exp3stim$targetSame)))) #2.09165339376488
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp3stim$targetSame)),as.character(tolower(exp3stim$targetSame)))) #2.09165339376488

mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp3stim$primeRep)),as.character(tolower(exp3stim$targetSame)))) #2.485782
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp3stim$primeUniq)),as.character(tolower(exp3stim$targetSame)))) #2.309813
mean(overlap_score(c(.7,1.5,1.5,1.5,1.5,1.5,1.5,1.5),as.character(tolower(exp3stim$primeCont)),as.character(tolower(exp3stim$targetSame)))) #0.2394494


table(overlap_score(sd7,as.character(tolower(exp3stim$targetSame)),as.character(tolower(exp3stim$targetSame)))) #2.09165339376488
mean(overlap_score(sd7,as.character(tolower(exp3stim$targetSame)),as.character(tolower(exp3stim$targetSame)))) #2.09165339376488, now 2.39685

mean(overlap_score(sd8,as.character(tolower(exp3stim$primeRep)),as.character(tolower(exp3stim$targetSame)))) #2.485782, now 2.772669
mean(overlap_score(sd8,as.character(tolower(exp3stim$primeUniq)),as.character(tolower(exp3stim$targetSame)))) #2.309813, now 2.598451
mean(overlap_score(sd8,as.character(tolower(exp3stim$primeCont)),as.character(tolower(exp3stim$targetSame)))) #0.2394494, now 0.2441123

